/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.AnimEventListener;
import com.jme3.animation.Track;
import com.jme3.audio.AudioNode;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.util.TempVars;
import java.io.IOException;

public class AudioTrack
implements Track {
    private AudioNode audio;
    private float startOffset = 0.0f;
    private float length = 0.0f;
    private boolean initialized = false;
    private boolean started = false;

    public AudioTrack() {
    }

    public AudioTrack(AudioNode audio, float length) {
        this.audio = audio;
        this.length = length;
    }

    public AudioTrack(AudioNode audio, float length, float startOffset) {
        this(audio, length);
        this.startOffset = startOffset;
    }

    public void setTime(float time, float weight, AnimControl control, AnimChannel channel, TempVars vars) {
        if (!this.initialized) {
            control.addListener(new OnEndListener());
            this.initialized = true;
        }
        if (!this.started && time >= this.startOffset) {
            this.started = true;
            this.audio.playInstance();
        }
    }

    private void stop() {
        this.audio.stop();
        this.started = false;
    }

    public float getLength() {
        return this.length;
    }

    public Track clone() {
        return new AudioTrack(this.audio, this.length, this.startOffset);
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule out = ex.getCapsule(this);
        out.write(this.audio, "audio", null);
        out.write(this.length, "length", 0.0f);
        out.write(this.startOffset, "startOffset", 0.0f);
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule in = im.getCapsule(this);
        this.audio = (AudioNode)in.readSavable("audio", null);
        this.length = in.readFloat("length", this.length);
        this.startOffset = in.readFloat("startOffset", 0.0f);
    }

    private class OnEndListener
    implements AnimEventListener {
        private OnEndListener() {
        }

        public void onAnimCycleDone(AnimControl control, AnimChannel channel, String animName) {
            AudioTrack.this.stop();
        }

        public void onAnimChange(AnimControl control, AnimChannel channel, String animName) {
            AudioTrack.this.stop();
        }
    }
}

